﻿//AddQRCode.jsx
//An InDesign JavaScript
/*  
@@@BUILDINFO@@@ "AddQRCode.jsx" 9.0.0 23 April 2013
*/
//Demonstrates how to add QR codes to a document. 
//To use this script open a new document.
//
//Options: QR code can either be placed on the placegun or directly as a page item.
//
//For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
//available at http://www.adobe.com/devnet/indesign/sdk.html
//or visit the InDesign Scripting User to User forum at http://www.adobeforums.com
//
main();
function main(){
    //Make sure a document is open.
	if (app.documents.length != 0){			
		myDisplayDialog();			
	}
	else{
		alert ("Please open a document.");
	}
}
function myDisplayDialog(){
	myDialog = app.dialogs.add({name:"AddQRCode"});
	with(myDialog){
            with(dialogColumns.add()){
                with(borderPanels.add()){
                    staticTexts.add({staticLabel:"QR Type:"});
                    var myButtons = radiobuttonGroups.add();
                    with(myButtons){
                        radiobuttonControls.add({staticLabel:"Web Hyperlink", checkedState:true});
                        radiobuttonControls.add({staticLabel:"Plain Text"});
                        radiobuttonControls.add({staticLabel:"Email"});
                        radiobuttonControls.add({staticLabel:"Text Message"});
                        radiobuttonControls.add({staticLabel:"Business Card"});
                    }
                }
             with(borderPanels.add()){
                staticTexts.add({staticLabel:"Options:"});
                var myDropdown = dropdowns.add({stringList:["Load on placegun", "Place as page item"] ,
                    selectedIndex:0}); 
                }
            }
        }
	var myReturn = myDialog.show();
	if (myReturn == true){
		//Get the values from the dialog box.
		var myQRType = myButtons.selectedButton;
         var myPlacingOption = myDropdown.selectedIndex;
		myDialog.destroy();
		myLoadQR(myQRType, myPlacingOption);
	}
	else{
		myDialog.destroy();
	}
}
function myLoadQR(myQRType, myPlacingOption){
    var myPage = app.activeDocument.pages.item(0);
    var myObject = app.activeDocument; //by default load QR code on document's placegun
    
    if(myPlacingOption == 1) { //if  place as page item is selected
        var myObject = myPage.rectangles.add();
        myObject.geometricBounds = [5, 5, 14, 14];
    }
    switch(myQRType){
    case 0: //Create QR Web Hyperlink
        var myURL = "http://www.adobe.com";
        myObject.createHyperlinkQRCode(myURL);
        break;
    case 1: //Create QR Plain Text
        var myText = "Display this text.";
        myObject.createPlainTextQRCode(myText);
        break;   
    case 2: //Create QR Email and use a magenta swatch
        var myEmailAddress = "someone@adobe.com";
        var subject = "This is the subject."
        var message = "This is body of the message."
        myObject.createEmailQRCode(myEmailAddress, subject, message, "Magenta");
        break;
    case 3: //Create QR Text Message
        var cellNumber = "12345678"
        var message = "This is a text message."
        myObject.createTextMsgQRCode(cellNumber, message, "None");
        break;
    case 4: //Create QR Business Card
        myObject.createVCardQRCode({firstName:"John", lastName:"Smith", cellPhone:"12345678", 
            email:"someone@adobe.com", organisation:"Adobe Systems", website:"www.adobe.com", 
            jobTitle:"Senior Manager", qrCodeSwatch:"Cyan"});      
        break;
    }
}